"use client"

import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { ComponentWithClassName } from "@/types/utils";
import { TransformedAgency } from "@/types/transformers";
import { Button } from "@/components/ui/button";
import { UploadCloud } from "lucide-react";

export function WorkflowButtonUpload({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedAgency> }>) {
  const { setWorkflow } = useApplicationWorkflow()
  if (data.access !== "ALL") {
    return;
  }

  return (
    <Button
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "UPLOAD_AGENCY_FEED",
        id: data.gtfsId,
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to upload new feed files for ${data.name}.`}
    >
      <UploadCloud className="size-3" />
    </Button>
  )
}

